IF EXISTS (SELECT
						 *
					 FROM
						 sys.objects
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[P_GERA_EST_PROD_PRC_BANDEIRA]') AND
						type IN ( N'P', N'PC' ))
	DROP PROCEDURE [dbo].P_GERA_EST_PROD_PRC_BANDEIRA

GO


CREATE PROCEDURE P_GERA_EST_PROD_PRC_BANDEIRA (@CD_PROD  INT=0)

AS

DECLARE @CD_BANDEIRA INT;
DECLARE _CURSOR CURSOR
FOR
 SELECT
  PRC_BANDEIRA.CD_BANDEIRA
 FROM
  PRC_BANDEIRA WHERE CD_BANDEIRA NOT IN (SELECT CD_BANDEIRA FROM EST_PROD_PRC_BANDEIRA WHERE CD_PROD = @CD_PROD)

OPEN _CURSOR

FETCH NEXT FROM _CURSOR INTO @CD_BANDEIRA

WHILE @@FETCH_STATUS <> -1
BEGIN

INSERT INTO EST_PROD_PRC_BANDEIRA
( CD_EMP,
           CD_PROD,
           CD_BANDEIRA,
           STS_PROD,
           CD_MOTIVO_STS,
           FLAG_PRODUTO_TAXA_ENTREGA,
           FLAG_VERBA_DESCON,
           FLAG_PROMO_FORN,
           FLAG_ANALISE_FALTAS,
           FLAG_ALTERAR_PRECO,
           FLAG_VENDA_CONSIGNADA,
           FLAG_IGNORAR_PMC_SUBST,
           FLAG_ANALISE_EXC_COB,
           FLAG_VD_CALL_CENTER,
           FLAG_NAO_PERMITIR_DEVOLUCAO,
           FLAG_NAO_CREDITAR_IMPOSTO,
           FLAG_NAO_FACEAR_AUTOMATICO,
           FLAG_RESSARCIMENTO,
           FLAG_ADJUDICACAO,
           FLAG_DESPESA_ACES,
           FLAG_DESCONTO_TICKET_BLQ,
           PROMO_INDUSTRIA,
           PROD_LIBERADO,
           FLAG_TROCA_FORNECEDOR,
           STS_PROD_CALL_CENTER,
           FLAG_NAO_APARECER_ESTATISTICA_COMPRA_CLIENTE,
           FLAG_NAO_ANALISAR_CUSTO,
           FLAG_PROD_CESTA_BASICA,
           FLAG_DIRETO_PDV,
           FLAG_PRODUTO_COTACAO,
           FLAG_VENDA_PERIODICA,
           PROD_USO_CONT,
           FLAG_PROD_DESPESA_ACES,
           DS_PROD,
           DS_USUAL,
           COMPRA_POR_SUPRIMENTO,
           CD_ARV_MERC_PAPEL,
			TP_VAN_COMPRA,
			REPO_PBM) 
SELECT  
           CD_EMP,
           @CD_PROD,
           @CD_BANDEIRA,
           STS_PROD,
           CD_MOTIVO_STS,
           FLAG_PRODUTO_TAXA_ENTREGA,
           FLAG_VERBA_DESCON,
           FLAG_PROMO_FORN,
           FLAG_ANALISE_FALTAS,
           FLAG_ALTERAR_PRECO,
           FLAG_VENDA_CONSIGNADA,
           FLAG_IGNORAR_PMC_SUBST,
           FLAG_ANALISE_EXC_COB,
           FLAG_VD_CALL_CENTER,
           FLAG_NAO_PERMITIR_DEVOLUCAO,
           FLAG_NAO_CREDITAR_IMPOSTO,
           FLAG_NAO_FACEAR_AUTOMATICO,
           FLAG_RESSARCIMENTO,
           FLAG_ADJUDICACAO,
           FLAG_DESPESA_ACES,
           FLAG_DESCONTO_TICKET_BLQ,
           PROMO_INDUSTRIA,
           PROD_LIBERADO,
           FLAG_TROCA_FORNECEDOR,
           STS_PROD_CALL_CENTER,
           FLAG_NAO_APARECER_ESTATISTICA_COMPRA_CLIENTE,
           FLAG_NAO_ANALISAR_CUSTO,
           FLAG_PROD_CESTA_BASICA,
           FLAG_DIRETO_PDV,
           FLAG_PRODUTO_COTACAO,
           FLAG_VENDA_PERIODICA,
           PROD_USO_CONT,
           FLAG_PROD_DESPESA_ACES,
           DS_PROD,
           DS_USUAL,
           COMPRA_POR_SUPRIMENTO,
           0,
           0,
           0
FROM EST_PROD 
WHERE CD_PROD = @CD_PROD
    

 FETCH NEXT FROM _CURSOR INTO @CD_BANDEIRA

END
DEALLOCATE _CURSOR
GO